Attribute VB_Name = "ComPorts"
Option Explicit

' Windows API 
Private Const DIGCF_PRESENT As Long = &H2
Private Const SPDRP_FRIENDLYNAME As Long = &HC
Private Const SPDRP_DEVICEDESC As Long = &H0
Private Const INVALID_HANDLE_VALUE As Long = -1

'  Windows API
Private Type GUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(7) As Byte
End Type

Private Type SP_DEVINFO_DATA
    cbSize As Long
    ClassGuid As GUID
    DevInst As Long
    Reserved As Long
End Type

' Windows API 
Private Declare Function SetupDiGetClassDevs Lib "setupapi.dll" _
    Alias "SetupDiGetClassDevsA" _
    (ByRef ClassGuid As GUID, _
     ByVal Enumerator As String, _
     ByVal hwndParent As Long, _
     ByVal Flags As Long) As Long

Private Declare Function SetupDiEnumDeviceInfo Lib "setupapi.dll" _
    (ByVal DeviceInfoSet As Long, _
     ByVal MemberIndex As Long, _
     ByRef DeviceInfoData As SP_DEVINFO_DATA) As Long

Private Declare Function SetupDiGetDeviceRegistryProperty Lib "setupapi.dll" _
    Alias "SetupDiGetDeviceRegistryPropertyA" _
    (ByVal DeviceInfoSet As Long, _
     ByRef DeviceInfoData As SP_DEVINFO_DATA, _
     ByVal Property As Long, _
     ByRef PropertyRegDataType As Long, _
     ByVal PropertyBuffer As String, _
     ByVal PropertyBufferSize As Long, _
     ByRef RequiredSize As Long) As Long

Private Declare Function SetupDiDestroyDeviceInfoList Lib "setupapi.dll" _
    (ByVal DeviceInfoSet As Long) As Long

'     GUID COM 
Private Function GetPortsGUID() As GUID
    With GetPortsGUID
        .Data1 = &H4D36E978
        .Data2 = &HE325
        .Data3 = &H11CE
        .Data4(0) = &HBF
        .Data4(1) = &HC1
        .Data4(2) = &H8
        .Data4(3) = &H0
        .Data4(4) = &H2B
        .Data4(5) = &HE1
        .Data4(6) = &H3
        .Data4(7) = &H18
    End With
End Function

'      COM 
Public Function GetCOMPortsList() As String
    Dim DeviceInfoSet As Long
    Dim DeviceInfoData As SP_DEVINFO_DATA
    Dim MemberIndex As Long
    Dim FriendlyName As String
    Dim PortName As String
    Dim Description As String
    Dim result As String
    Dim portCount As Integer
    Dim portsGUID As GUID
    
    '  GUID  COM 
    portsGUID = GetPortsGUID()
    
    '   
    DeviceInfoSet = SetupDiGetClassDevs(portsGUID, _
                                       vbNullString, _
                                       0, _
                                       DIGCF_PRESENT)
    
    If DeviceInfoSet = INVALID_HANDLE_VALUE Then
        GetCOMPortsList = "Error: Cannot get device information"
        Exit Function
    End If
    
    '  
    DeviceInfoData.cbSize = Len(DeviceInfoData)
    MemberIndex = 0
    portCount = 0
    result = "=== COM Ports List ===" & vbCrLf & vbCrLf
    
    '   
    While SetupDiEnumDeviceInfo(DeviceInfoSet, MemberIndex, DeviceInfoData)
        '  Friendly Name
        FriendlyName = GetDeviceProperty(DeviceInfoSet, DeviceInfoData, SPDRP_FRIENDLYNAME)
        
        '   ,  COM 
        If FriendlyName <> "" Then
            PortName = ExtractCOMPort(FriendlyName)
            Description = GetDeviceProperty(DeviceInfoSet, DeviceInfoData, SPDRP_DEVICEDESC)
            
            '   
            result = result & "Port " & (portCount + 1) & ":" & vbCrLf
            result = result & "  Name: " & PortName & vbCrLf
            result = result & "  Friendly Name: " & FriendlyName & vbCrLf
            If Description <> "" Then
                result = result & "  Description: " & Description & vbCrLf
            End If
            result = result & vbCrLf
            
            portCount = portCount + 1
        End If
        
        MemberIndex = MemberIndex + 1
    Wend
    
    '  
    SetupDiDestroyDeviceInfoList DeviceInfoSet
    
    If portCount = 0 Then
        result = result & "No COM ports found"
    Else
        result = result & "Total found: " & portCount & " ports"
    End If
    
    GetCOMPortsList = result
End Function

'     
Private Function GetDeviceProperty( _
    ByVal DeviceInfoSet As Long, _
    ByRef DeviceInfoData As SP_DEVINFO_DATA, _
    ByVal Property As Long) As String
    
    Dim PropertyBuffer As String
    Dim RequiredSize As Long
    Dim PropertyRegDataType As Long
    Dim result As Long
    
    '     
    result = SetupDiGetDeviceRegistryProperty( _
        DeviceInfoSet, _
        DeviceInfoData, _
        Property, _
        PropertyRegDataType, _
        vbNullString, _
        0, _
        RequiredSize)
    
    If RequiredSize > 0 Then
        '    
        PropertyBuffer = String(RequiredSize, 0)
        
        '  
        result = SetupDiGetDeviceRegistryProperty( _
            DeviceInfoSet, _
            DeviceInfoData, _
            Property, _
            PropertyRegDataType, _
            PropertyBuffer, _
            Len(PropertyBuffer), _
            RequiredSize)
        
        If result <> 0 Then
            '   
            GetDeviceProperty = Left(PropertyBuffer, InStr(PropertyBuffer, Chr(0)) - 1)
        End If
    End If
End Function

'     COM   Friendly Name
Private Function ExtractCOMPort(ByVal FriendlyName As String) As String
    Dim startPos As Long
    Dim endPos As Long
    
    '  "(COM"  
    startPos = InStr(1, FriendlyName, "(COM", vbTextCompare)
    If startPos > 0 Then
        '   
        endPos = InStr(startPos, FriendlyName, ")", vbTextCompare)
        If endPos > startPos Then
            '   
            ExtractCOMPort = Mid(FriendlyName, startPos + 1, endPos - startPos - 1)
            Exit Function
        End If
    End If
    
    '      (COMx),   
    ExtractCOMPort = FriendlyName
End Function

